/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

#ifndef __REG_40_h__
#define __REG_40_h__

/* ***********************************************************************
   *                                                                     *
   * regx40.h                                                            *
   * Tilmann Wendel , BID R&D, 12. Jan. 1998                             *
   *                                                                     *
   * defines for second command byte and 16-bit commands                 *
   *                                                                     *
   * performance lockable actions are stored in this page                *
   *                                                                     *
   ***********************************************************************
*/


#include "regxdir.h"


#define MERGE_PERFACTION_LOCK(cmd)	CMD_MERGE (CMDG_PERFACTION_LOCK, cmd)

/* BestPerfRun() */
#define CMDM_PERF_RUN		0x06
#define CMD_PERF_RUN		MERGE_PERFACTION_LOCK (CMDM_PERF_RUN)
#define IN_PERF_RUN		 0
#define OUT_PERF_RUN		 0

/* BestPerfStop() */
#define CMDM_PERF_STOP		0x07
#define CMD_PERF_STOP		MERGE_PERFACTION_LOCK (CMDM_PERF_STOP)
#define IN_PERF_STOP		 0
#define OUT_PERF_STOP		 0

/* BestPerfUpdate() */
#define CMDM_PERF_UPDATE	0x08
#define CMD_PERF_UPDATE		MERGE_PERFACTION_LOCK (CMDM_PERF_UPDATE)
#define IN_PERF_UPDATE		 0
#define OUT_PERF_UPDATE		 0

#endif
